/* File parser.mly */

%{
  open Sread_expr
  let list_type l r =
    match (l, r) with 
	("(", ")") -> Paren
      | ("{", "}") -> Brace
      | ("[", "]") -> Bracket
      | _ -> failwith (Printf.sprintf 
			 "Unexpected closing character %s for %s" r l)
  ;;	  
%}


%token <string> LPAREN
%token <string> RPAREN
%token <string> QUOTE
%token <string> ATOM

%start expr
%type <Sread_expr.expr> expr



%%


expr:  list         { $1 }
     | atom         { $1 }
     | quoted_expr  { $1 }
;

atom: ATOM          { Atom $1 }  
;  


list:  LPAREN RPAREN  { List (list_type $1 $2, []) }
     | LPAREN expr_plus RPAREN { List (list_type $1 $3, $2) }
;


expr_plus: expr { [$1] }
     | expr expr_plus { $1 :: $2 }
;

quoted_expr: QUOTE expr { List(Paren, [Atom $1; $2]) }
;
