{
  open Sread_parser
  exception Eof

  (* quick function to chop out the left and right sides of a string.
     Used on quoted strings to get rid of the quotes on the sides. *)
  let chop_edges s =
    String.sub s 1 (String.length s - 2)
  ;;
}

let nq = ('\\' '"') | ([^ '"'])   (* nonquote characters *)
let w = ['a'-'z' 'A'-'Z' '0'-'9' '_']  (* word characters *)
let s = ['!' '@' '#' '$' '%' '^' '&' '*' '_' '-' '+' '=' '|' 
           ';' ':' '/' '?' '<' '>']  (* symbol characters *)


rule token = parse
    [' ' '\t' '\n' '\r'] { token lexbuf }   (* skip whitespace*)
  | '(' { LPAREN("(") }
  | ')' { RPAREN(")") }
  | '[' { LPAREN("[") }
  | ']' { RPAREN("]") }
  | '{' { LPAREN("{") }
  | '}' { RPAREN("}") }
  | '\'' { QUOTE("QUOTE") }
  | ',' { QUOTE("UNQUOTE") }
  | '`' { QUOTE("QUASIQUOTE") }
  | (w | s)+ { ATOM (Lexing.lexeme lexbuf) }
  | '"' nq* '"' { ATOM (chop_edges(Lexing.lexeme lexbuf)) }  (* quoted strings *)
  | eof { raise Eof }
