(* A concrete type to represent Lisp-like list expressions *)

type paren_type =
    Paren
  | Brace
  | Bracket
;;


type expr = 
    List of paren_type * expr list
  | Atom of string
;;


let strings_of_paren_type paren_type =
  match paren_type with 
      Paren -> ("(", ")")
    | Brace -> ("{", "}")
    | Bracket -> ("[", "]")
;;


(* Little debug function to print out expressions *)
let rec string_of_expr =
  function
      List (paren_type, list) -> 
	let (lparen, rparen) = strings_of_paren_type paren_type
	in
	  lparen ^ 
	  String.concat ", " (List.map string_of_expr list) ^
	  rparen
    | Atom s -> "\"" ^ String.escaped s ^ "\""
;;
