(**
  Sread: Scheme-like READ for Ocaml

  @author Danny Yoo (dyoo at hkn.eecs.berkeley.edu)

  This library makes it relatively easy to parse out Scheme lists into
  OCaml data structures.  For example:


# Sread.read_from_string "(this is a test '(yes it is))";;
- : Sread.sexpr =
Sread.List
 [Sread.Atom "this"; Sread.Atom "is"; Sread.Atom "a"; Sread.Atom "test";
  Sread.List
   [Sread.Atom "QUOTE";
    Sread.List [Sread.Atom "yes"; Sread.Atom "it"; Sread.Atom "is"]]]

*)



(** AST that represents the parsed list structure *)
type sexpr =
    List of sexpr list
  | Atom of string;;


(** Given an in_channel, returns a function that, when called, returns
  the next sexpr that can be parsed from the in_channel.  *)
val read_from_channel: in_channel -> unit -> sexpr


(** Given a string, returns the first sexpr that can be parsed from
  that string *)
val read_from_string: string -> sexpr


(** Given an sexpr, returns a string representation of that sexpr.*)
val string_of_sexpr: sexpr -> string
