
type sexpr =
    List of sexpr list
  | Atom of string;;

let rec sexpr_of_expr expr =
  match expr with
      Sread_expr.List(ptype, explist) -> 
	List(List.map sexpr_of_expr explist)
    | Sread_expr.Atom(s) -> Atom(s)
;;


let read_from_channel channel =
  let buf = Lexing.from_channel channel in
    function () -> 
      sexpr_of_expr(Sread_parser.expr Sread_lexer.token buf)


let read_from_string s =
  let buf = Lexing.from_string s in
    sexpr_of_expr(Sread_parser.expr Sread_lexer.token buf)


let rec string_of_sexpr =
  function
      List (list) -> 
	"(" ^ 
	String.concat ", " (List.map string_of_sexpr list) ^
	")"
    | Atom s -> "\"" ^ String.escaped s ^ "\""
;;

